package de.davidartmann.rosa.adapter;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.ViewPager;

import java.util.ArrayList;
import java.util.List;

import de.davidartmann.rosa.db.async.FindAllActivePersonsFromDb;
import de.davidartmann.rosa.fragment.DetailFragment;
import de.davidartmann.rosa.model.Person;

/**
 * ViewPager adapter class.
 * Created by david on 03.03.16.
 */
public class ViewPagerAdapter extends FragmentStatePagerAdapter
        implements FindAllActivePersonsFromDb.IFindAllActive {

    private List<Person> mPersons;
    private ViewPager mViewPager;
    private Person mPerson;
    private IViewPagerAdapter iViewPagerAdapter;

    public ViewPagerAdapter(FragmentManager fm, Context context, ViewPager viewPager,
                            Person person, IViewPagerAdapter iViewPagerAdapter) {
        super(fm);
        mPersons = new ArrayList<>();
        mViewPager = viewPager;
        mPerson = person;
        this.iViewPagerAdapter = iViewPagerAdapter;
        new FindAllActivePersonsFromDb(context, this).execute();
    }

    @Override
    public Fragment getItem(int position) {
        return DetailFragment.newInstance(mPersons.get(position));
    }

    @Override
    public int getCount() {
        return mPersons.size();
    }

    @Override
    public CharSequence getPageTitle(int position) {
        return mPersons.get(position).getName();
    }

    @Override
    public void onFindAllActive(List<Person> persons) {
        if (this.mPersons != null) {
            this.mPersons.clear();
            this.mPersons.addAll(persons);
        } else {
            this.mPersons = persons;
        }
        notifyDataSetChanged();
        mViewPager.setCurrentItem(mPerson.getPosition() - 1);
        iViewPagerAdapter.onLoaded();
    }

    public interface IViewPagerAdapter {
        void onLoaded();
    }
}
